/* eslint-disable max-len,camelcase */
define([
    'underscore',
    'App',
    'Vent',
    'modules/community-care-request/view/community-care-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/community-care-request/new-appointment-request-question/facility-caretype-selection/facility-section-view',
    'modules/community-care-request/new-appointment-request-question/facility-caretype-selection/caretype-section-view',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferred-provider-layout-view',
    'modules/community-care-request/new-appointment-request-question/request-preferences/community-care-appointment-preferences-layout-view',
    'text!modules/community-care-request/new-appointment-request-question/facility-caretype-selection/community-care-facility-caretype-layout.html',
],
function(
    _,
    app,
    vent,
    CommunityCareView,
    WizardStepModel,
    FacilitySectionView,
    CareTypeSectionView,
    PrimaryCareLayoutView,
    AppointmentPreferencesLayoutView,
    template
) {
    'use strict';

    // TODO make a Wizard Page Layout View that this can extend to make some methods such as declaimFDNS   trols, disableContinue, enableContinue, showPrevious DRY
    return CommunityCareView.extend({
        template: _.template(template),
        regions: {
            facilitySelectionSection: '.facility-selection-section',
            careTypeSelectionSection: '.caretype-selection-section',
        },
        modelEvents: {
            'change:facility': 'handleModelChange',
            'change:careTypeContinue': 'handleModelChange',
        },
        handleModelChange: function () {
            if (this.validator.checkForm() && this.model.get('careTypeContinue') === 'yes') {
                this.enableContinueButton();
            } else {
                this.disableContinueButton();
            }
        },
        initialize: function (options) {
            if (_.isUndefined(options)) {
                this.model = new WizardStepModel.Model();
            } else {
                this.model = options.model;
            }
            this.validator = options.validator;
        },
        onRender: function () {
            var steps = this.model.get('steps');

            $.when(app.patientEnrolledFacilities.isReady).then(function () {
                var facility;

                this.showChildView('facilitySelectionSection', new FacilitySectionView({
                    model: this.model,
                    step: steps[0],
                    patientEnrolledFacilities: app.patientEnrolledFacilities,
                    hasMultiFacilities: this.hasMultiFacilities(),
                }));

                if (app.patientEnrolledFacilities.length === 1) {
                    // patient has single registered facility
                    facility = app.patientEnrolledFacilities.at(0);
                    this.model.set('facility', facility);
                }
            }.bind(this));

            this.showChildView('careTypeSelectionSection', new CareTypeSectionView({
                model: this.model,
                step: steps[1],
                validator: this.validator,
                ccTypeOfCares: app.ccTypeOfCares,
            }));
        },
        onDomRefresh: function() {
            if (!this.validator.checkForm() || this.model.get('careTypeContinue') === 'no') {
                this.disableContinueButton();
            }
        },
        toContinue: function() {
            if (this.model.get('careType') === 'CCPCPRVDR') {
                vent.trigger('show:nextWizardPage', PrimaryCareLayoutView, 1);
            } else {
                if (!this.model.get('optionTime1')) {
                    this.model.set('optionTime1', 'AM');
                }
                vent.trigger('show:nextWizardPage', AppointmentPreferencesLayoutView, 1);
            }
        },
        hasMultiFacilities: function() {
            return app.patientIdentifiers.getDfnSiteCodes().length > 1;
        },
    });
});
